<?php
// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Methods: POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
header('Content-Type: application/json');
session_start();
require_once '../../config/config.php';
include '../functions.php';

// Fetch Token
$tokenData = getEversendToken();

// Allow only POST requests
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit();
}

try {
    // Get and decode JSON input
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    if (!$data) {
        throw new Exception('Invalid JSON data');
    }

    // Define required fields
    $required_fields = ['method', 'currency', 'amount'];
    foreach ($required_fields as $field) {
        if (!isset($data[$field]) || empty(trim($data[$field]))) {
            throw new Exception("$field is required");
        }
    }

    // Sanitize and validate inputs
    $method = filter_var(trim($data['method']), FILTER_SANITIZE_STRING);
    $currency = filter_var(trim($data['currency']), FILTER_SANITIZE_STRING);
    $amount = filter_var(trim($data['amount']), FILTER_VALIDATE_FLOAT);

    //Check if amount is less than minimum allowed
    if ($amount < 500) {
        throw new Exception('Minimum amount is UGX 500/-');
    }
    
    //Check if amount is more than maximum allowed
    if ($amount > 4000000) {
        throw new Exception('Maximum amount is UGX 4,000,000/-');
    }

   // Calculate service fee (2% of amount) and always round up to the next integer
   // Fetch Collection Service fee
    $deposit_commission = 0;
    $service_fee = ceil($amount * $deposit_commission);



    // Send request to Eversend API
    $payload = json_encode([
        'method' => $method,
        'currency' => $currency,
        'amount' => $amount
    ]);

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://api.eversend.co/v1/collections/fees',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            "Authorization: Bearer {$tokenData}"
        ],
    ]);

    $response = curl_exec($curl);
    $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    if ($http_status !== 200) {
        throw new Exception("Deposit Failed");
    }

    // Decode API response and append service fee
    $response_data = json_decode($response, true);
    $response_data['data']['service_fee'] = $service_fee;
    $response_data['data']['charges'] = $response_data['data']['charges'] + $service_fee;
    $response_data['data']['total_to_pay'] = $response_data['data']['total_to_pay'] + $service_fee;
     $response_data['data']['payable_amount'] = $service_fee + $response_data['data']['amount'] ;

    echo json_encode($response_data);
} catch (Exception $e) {
    // Return error response
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Deposit failed',
        'error' => $e->getMessage()
    ]);
}
?>
