<?php
include "../connect.php";

// Log function
function logTransaction($message, $type = "info")
{
    $logDir = __DIR__ . "/logs";
    if (!is_dir($logDir)) {
        mkdir($logDir, 0777, true); // Ensure logs directory exists
    }
    $logFile = $logDir . "/transaction_log_" . date("Y-m-d") . ".log";
    $logMessage = "[" . date("Y-m-d H:i:s") . "] [$type] $message" . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

// Update Wallet
function updateWalletAmount($conn, $amount, $uuid, $currency, $isAdd = true)
{
    try {
        $amount = $isAdd ? abs($amount) : -abs($amount);

        $stmt = $conn->prepare(
            "UPDATE wallets SET amount = amount + ? WHERE uuid = ? AND currency = ?"
        );
        if (!$stmt->execute([$amount, $uuid, $currency])) {
            throw new Exception("Failed to update wallet.");
        }

        logTransaction(
            "Wallet " .
                ($isAdd ? "credited" : "debited") .
                " for UUID: $uuid, Amount: $amount, Currency: $currency"
        );
        return true;
    } catch (Exception $e) {
        logTransaction("Error updating wallet: " . $e->getMessage(), "error");
        return false;
    }
}

// Insert Earnings
function insertPayments(
    $conn,
    $uuid,
    $order_id,
    $amount,
    $payment_method,
    $status = "completed"
) {
    try {
        if ($isAdd) {
            $stmt = $conn->prepare(
                "INSERT INTO payments (user_id, order_id, transaction_ref, 	amount, payment_method, status, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())"
            );
            if (
                !$stmt->execute([
                    $uuid,
                    $currency,
                    $transaction_ref,
                    $service_name,
                    $status,
                    $service_fee,
                ])
            ) {
                throw new Exception("Failed to insert earnings.");
            }
            logTransaction(
                "Earnings recorded for UUID: $uuid, Amount: $service_fee, Currency: $currency, Service: $service_name, Status: $status"
            );
        } else {
            $stmt = $conn->prepare(
                "DELETE FROM earnings WHERE transaction_ref = ?"
            );
            if (!$stmt->execute([$transaction_ref])) {
                throw new Exception("Failed to delete earnings.");
            }
            logTransaction(
                "Earnings deleted for Transaction Ref: $transaction_ref"
            );
        }
        return true;
    } catch (Exception $e) {
        logTransaction(
            "Error processing earnings: " . $e->getMessage(),
            "error"
        );
        return false;
    }
}

// Update Commission
function updateCommission($conn, $service_fee, $currency, $isAdd = true)
{
    try {
        $service_fee = $isAdd ? abs($service_fee) : -abs($service_fee);

        $stmt = $conn->prepare(
            "UPDATE commission SET amount = amount + :service_fee WHERE wallet = :currency"
        );
        if (
            !$stmt->execute([
                ":service_fee" => $service_fee,
                ":currency" => $currency,
            ])
        ) {
            throw new Exception("Failed to update commission.");
        }

        logTransaction(
            "Commission updated for Currency: $currency, Service Fee: $service_fee"
        );
        return true;
    } catch (Exception $e) {
        logTransaction(
            "Error updating commission: " . $e->getMessage(),
            "error"
        );
        return false;
    }
}

// Insert User Action Log
function insertAuditLog($conn, $uuid, $action, $user_agent, $ip_address)
{
    try {
        $stmt = $conn->prepare(
            "INSERT INTO audit_logs (uuid, action, user_agent, ip_address, created_at) VALUES (?, ?, ?, ?, NOW())"
        );
        if (!$stmt->execute([$uuid, $action, $user_agent, $ip_address])) {
            throw new Exception("Failed to insert audit log.");
        }
        logTransaction("Audit log inserted for UUID: $uuid, Action: $action");
        return true;
    } catch (Exception $e) {
        logTransaction(
            "Error inserting audit log: " . $e->getMessage(),
            "error"
        );
        return false;
    }
}

?>
